/*
    File: BMP.h

    Copyright 1992 by Adobe Systems, Inc.
    
    Written by  Marc Kaufman
                Kaufman Research
                17 Mountain Meadow
                Woodside, CA  94062
                (415) 851-5777
 */


/*
#include <PITypes.h>
#include <PIAbout.h>
#include <PIExtension.h>
#include <ESDisplay.h>
*/
#include <Traps.h>

/*  Making a local A5 world plays havoc with dialog interaction, as we would
    have to keep going back and forth between worlds during the dialog.  We
    take the simple way out:  Use an explicitly defined structure for all
    pseudo-global data.
 */

typedef struct GlobalData
	{

//    ExtensionRecord 	*gExt;
//    ToggleCopyBitsProc	*gOldToggleCopyBits;
//	DrawOutlineProc		*gOldDrawOutline;
//	CopyPatternedProc	*gOldCopyPatterned;
	Handle				 gRegionBits;
	unsigned long		 g24Mask;
	unsigned short		 g16Mask;
	
	/* Data above this is also used by the assembly code.  Below is exclusive to C */
	Boolean				 need32check;
	Boolean				 checkScreen;

	} GlobalData, *GPtr;

/*****************************************************************************/

/* Local Function Prototypes.
 */

#ifdef __powerc

#define FixPC()

#define Set32BitMode()

#define Clear32BitMode()

#else

pascal void FixPC()
	= {	0x41FA, 0x000A,		/*			LEA			*+12,A0			*/
		0x2008,				/*			MOVE.L		A0,D0			*/
		_StripAddress,		/*			_StripAddress				*/
		0x2040,				/*			MOVEA.L		D0,A0			*/
		0x4ED0 };			/*			JMP			(A0) ; jmps to next instruction	*/
		
pascal void Set32BitMode()
    = {	0x7001,             /*          MOVEQ       #true32b,D0     */
        _SwapMMUMode };		/*          _SwapMMUMode                */

pascal void Clear32BitMode()
    = {	0x7000,             /*          MOVEQ       #false32b,D0    */
        _SwapMMUMode };		/*          _SwapMMUMode                */

#endif

#if 0
OSErr   DoAbout (void);
OSErr	DoInitialize (GPtr data);
OSErr	DoTerminate (GPtr data);

#ifdef __powerc
extern GlobalData theGlobalData;

#define GetGlobalData() &theGlobalData;

#else

pascal GPtr GetGlobalData (void);

#endif
#endif

/*****************************************************************************/

/* Declarations for glue to call old version of bottlenecks. */

pascal void DirectToggleCopyBits (PixMap *map,
							  const Rect *srcRect,
							  const Rect *dstRect,
							  RgnHandle maskRgn);
							  							  
/*****************************************************************************/

/* Declarations for simple bit twidling operations. */

pascal void	DoClearLongs (unsigned long *dPtr, int16 count);

pascal void DoInvertBits (unsigned long *dPtr, int16 count, int16 offset);

/*****************************************************************************/

/* Declarations for sparse blit operations for each screen depth. */

pascal void AddDirect8 (const unsigned long *sPtr,
				 		unsigned char *dPtr,
				 		const unsigned long *mPtr,
				 		int16 rows,
				 		int16 rowSize,
				 		int16 sRowBytes,
				 		int16 dRowBytes);
							  
pascal void AddDirect16 (const unsigned long *sPtr,
						 unsigned short *dPtr,
						 const unsigned long *mPtr,
						 int16 rows,
						 int16 rowSize,
						 int16 sRowBytes,
						 int16 dRowBytes);
							  
pascal void AddDirect32 (const unsigned long *sPtr,
						 unsigned long *dPtr,
						 const unsigned long *mPtr,
						 int16 rows,
						 int16 rowSize,
						 int16 sRowBytes,
						 int16 dRowBytes);

/*****************************************************************************/

int initDirectBits();
void cleanupDirectBits();
